/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.village;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.BlockPixieHouse;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouseModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class PixieVillagePieces {
    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(PixieHouse.class, (String)"ViBH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"ViW");
    }

    public static List<PieceWeight> getStructureVillageWeightedPieceList(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeight(PixieHouse.class, 75, 10));
        list.add(new PieceWeight(Road.class, 25, 12));
        return list;
    }

    private static int updatePieceWeight(List<PieceWeight> p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight PixieVillagePieces$pieceweight : p_75079_0_) {
            if (PixieVillagePieces$pieceweight.villagePiecesLimit > 0 && PixieVillagePieces$pieceweight.villagePiecesSpawned < PixieVillagePieces$pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += PixieVillagePieces$pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village findAndCreateComponentFactory(Start start, PieceWeight weight, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        Class<? extends Village> oclass = weight.villagePieceClass;
        PixieHouse village = PixieHouse.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        return village;
    }

    private static Village generateComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        int i = PixieVillagePieces.updatePieceWeight(start.structureVillageWeightedPieceList);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = rand.nextInt(i);
            for (PieceWeight PixieVillagePieces$pieceweight : start.structureVillageWeightedPieceList) {
                if ((k -= PixieVillagePieces$pieceweight.villagePieceWeight) >= 0) continue;
                if (!PixieVillagePieces$pieceweight.canSpawnMoreVillagePiecesOfType(componentType) || PixieVillagePieces$pieceweight == start.structVillagePieceWeight && start.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village PixieVillagePieces$village = PixieVillagePieces.findAndCreateComponentFactory(start, PixieVillagePieces$pieceweight, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
                if (PixieVillagePieces$village == null) continue;
                ++PixieVillagePieces$pieceweight.villagePiecesSpawned;
                start.structVillagePieceWeight = PixieVillagePieces$pieceweight;
                if (!PixieVillagePieces$pieceweight.canSpawnMoreVillagePieces()) {
                    start.structureVillageWeightedPieceList.remove(PixieVillagePieces$pieceweight);
                }
                return PixieVillagePieces$village;
            }
        }
        return null;
    }

    private static StructureComponent generateAndAddComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        if (componentType > 50) {
            return null;
        }
        if (Math.abs(structureMinX - start.func_74874_b().field_78897_a) <= 112 && Math.abs(structureMinZ - start.func_74874_b().field_78896_c) <= 112) {
            Village structurecomponent = PixieVillagePieces.generateComponent(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType + 1);
            if (structurecomponent != null) {
                structureComponents.add(structurecomponent);
                start.pendingHouses.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    private static StructureComponent generateAndAddRoadPiece(Start start, List<StructureComponent> p_176069_1_, Random rand, int p_176069_3_, int p_176069_4_, int p_176069_5_, EnumFacing facing, int p_176069_7_) {
        if (p_176069_7_ > 3 + start.terrainType) {
            return null;
        }
        if (Math.abs(p_176069_3_ - start.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176069_5_ - start.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = Path.findPieceBox(start, p_176069_1_, rand, p_176069_3_, p_176069_4_, p_176069_5_, facing);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 0) {
                Path structurecomponent = new Path(start, p_176069_7_, rand, structureboundingbox, facing);
                p_176069_1_.add(structurecomponent);
                start.pendingRoads.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    public static class PixieHouse
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        public PixieHouse() {
        }

        public PixieHouse(Start start, int type, Random rand, StructureBoundingBox structurebb, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = structurebb;
            this.isTallHouse = rand.nextBoolean();
            this.tablePosition = rand.nextInt(3);
        }

        public static PixieHouse createPiece(Start start, List<StructureComponent> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing facing, int p_175853_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)1, (int)1, (int)1, (EnumFacing)facing);
            return PixieHouse.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175853_1_, (StructureBoundingBox)structureboundingbox) == null ? new PixieHouse(start, p_175853_7_, rand, structureboundingbox, facing) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("T", this.tablePosition);
            tagCompound.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
            super.readStructureFromNBT(tagCompound);
            this.tablePosition = tagCompound.func_74762_e("T");
            this.isTallHouse = tagCompound.func_74767_n("C");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e, 0);
            }
            this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), 0, -1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ModBlocks.pixieHouse.func_176223_P().func_177226_a((IProperty)BlockPixieHouse.FACING, (Comparable)(this.func_186165_e() == null ? EnumFacing.NORTH : this.func_186165_e().func_176734_d())), 0, 0, 0, structureBoundingBoxIn);
            BlockPos blockpos = new BlockPos(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0));
            if (worldIn.func_175625_s(blockpos) instanceof TileEntityPixieHouse) {
                int houseType;
                ((TileEntityPixieHouse)worldIn.func_175625_s((BlockPos)blockpos)).houseType = houseType = randomIn.nextInt(5);
            }
            worldIn.func_147458_c(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), blockpos.func_177958_n() + 1, blockpos.func_177956_o() + 1, blockpos.func_177952_p() + 1);
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 0, 1, 0, 1);
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class Well
    extends Village {
        private static final WorldGenCanopyTree TREE_GEN = new WorldGenCanopyTree(true);

        public Well() {
        }

        public Well(Start start, int type, Random rand, int x, int z) {
            super(start, type);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, 64, z, x + 3, 64, z + 3) : new StructureBoundingBox(x, 64, z, x + 3, 64, z + 3);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 2, EnumFacing.WEST, this.func_74877_c());
            PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 2, EnumFacing.EAST, this.func_74877_c());
            PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 2, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c, EnumFacing.NORTH, this.func_74877_c());
            PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 2, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(1, this.averageGroundLvl - this.field_74887_e.field_78894_e - 1, 1);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 3, 0, 3, Blocks.field_150349_c.func_176223_P(), Blocks.field_185774_da.func_176223_P(), false);
            BlockPos blockpos = new BlockPos(this.func_74865_a(1, 2), this.func_74862_a(1), this.func_74873_b(1, 2));
            TREE_GEN.func_180709_b(worldIn, randomIn, blockpos);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 3, 0, 3, Blocks.field_185774_da.func_176223_P(), Blocks.field_185774_da.func_176223_P(), false);
            for (int l = 0; l < 3; ++l) {
                for (int k = 0; k < 3; ++k) {
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), l, -1, k, structureBoundingBoxIn);
                }
            }
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static abstract class Village
    extends StructureComponent {
        protected int averageGroundLvl = -1;
        protected int field_189928_h;
        protected boolean field_189929_i;
        protected Start startPiece;
        private int villagersSpawned;

        public Village() {
        }

        protected Village(Start start, int type) {
            super(type);
            if (start != null) {
                this.field_189928_h = start.field_189928_h;
                this.field_189929_i = start.field_189929_i;
                this.startPiece = start;
            }
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox structurebb) {
            return structurebb != null && structurebb.field_78895_b > 10;
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("HPos", this.averageGroundLvl);
            tagCompound.func_74768_a("VCount", this.villagersSpawned);
            tagCompound.func_74774_a("Type", (byte)this.field_189928_h);
            tagCompound.func_74757_a("Zombie", this.field_189929_i);
        }

        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
            this.averageGroundLvl = tagCompound.func_74762_e("HPos");
            this.villagersSpawned = tagCompound.func_74762_e("VCount");
            this.field_189928_h = tagCompound.func_74771_c("Type");
            if (tagCompound.func_74767_n("Desert")) {
                this.field_189928_h = 1;
            }
            this.field_189929_i = tagCompound.func_74767_n("Zombie");
        }

        protected StructureComponent getNextComponentNN(Start start, List<StructureComponent> structureComponents, Random rand, int p_74891_4_, int p_74891_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(Start start, List<StructureComponent> structureComponents, Random rand, int p_74894_4_, int p_74894_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return PixieVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int getAverageGroundLevel(World worldIn, StructureBoundingBox structurebb) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 64, k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i() - 1);
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected void spawnVillagers(World worldIn, StructureBoundingBox structurebb, int x, int y, int z, int count) {
            if (this.villagersSpawned < count) {
                int l;
                int k;
                int j;
                for (int i = this.villagersSpawned; i < count && structurebb.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(x + i, z), k = this.func_74862_a(y), l = this.func_74873_b(x + i, z))); ++i) {
                    ++this.villagersSpawned;
                    EntityPixie entityPixie = new EntityPixie(worldIn);
                    entityPixie.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    entityPixie.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityPixie)), null);
                    worldIn.func_72838_d((Entity)entityPixie);
                }
            }
        }

        @Deprecated
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return currentVillagerProfession;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
            return VillagerRegistry.getById((int)this.chooseProfession(count, VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof)));
        }

        protected IBlockState getBiomeSpecificBlockState(IBlockState blockstateIn) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, blockstateIn);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getReplacement();
            }
            if (this.field_189928_h == 1) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.DEFAULT.func_176675_a());
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a());
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                    return Blocks.field_150322_A.func_176223_P();
                }
            } else if (this.field_189928_h == 3) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180408_aP.func_176223_P();
                }
            } else if (this.field_189928_h == 2) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150400_ck.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180405_aT.func_176223_P();
                }
            }
            return blockstateIn;
        }

        protected void func_175808_b(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(blockstateIn);
            super.func_175808_b(worldIn, iblockstate, x, y, z, boundingboxIn);
        }

        protected void func_189924_a(int p_189924_1_) {
            this.field_189928_h = p_189924_1_;
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider worldChunkMngr;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List<PieceWeight> structureVillageWeightedPieceList;
        public List<StructureComponent> pendingHouses = Lists.newArrayList();
        public List<StructureComponent> pendingRoads = Lists.newArrayList();
        public Biome biome;

        public Start() {
        }

        public Start(BiomeProvider chunkManagerIn, int p_i2104_2_, Random rand, int p_i2104_4_, int p_i2104_5_, List<PieceWeight> p_i2104_6_, int p_i2104_7_) {
            super(null, 0, rand, p_i2104_4_, p_i2104_5_);
            Biome biome;
            this.worldChunkMngr = chunkManagerIn;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            this.biome = biome = chunkManagerIn.func_180300_a(new BlockPos(p_i2104_4_, 0, p_i2104_5_), Biomes.field_180279_ad);
            this.startPiece = this;
            this.func_189924_a(this.field_189928_h);
            this.field_189929_i = rand.nextInt(50) == 0;
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start start, int type) {
            super(start, type);
        }
    }

    public static class PieceWeight {
        public final int villagePieceWeight;
        public Class<? extends Village> villagePieceClass;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class<? extends Village> p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int componentType) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int length;

        public Path() {
        }

        public Path(Start start, int p_i45562_2_, Random rand, StructureBoundingBox p_i45562_4_, EnumFacing facing) {
            super(start, p_i45562_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45562_4_;
            this.length = Math.max(p_i45562_4_.func_78883_b(), p_i45562_4_.func_78880_d());
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> p_175848_1_, Random rand, int p_175848_3_, int p_175848_4_, int p_175848_5_, EnumFacing facing) {
            for (int i = 3 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 3; i -= 3) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)1, (int)1, (int)i, (EnumFacing)facing);
                if (StructureComponent.func_74883_a(p_175848_1_, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Length", this.length);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
            super.readStructureFromNBT(tagCompound);
            this.length = tagCompound.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.length - 8; i += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent = this.getNextComponentNN((Start)componentIn, listIn, rand, 0, i);
                if (structurecomponent == null) continue;
                i += Math.max(structurecomponent.func_74874_b().func_78883_b(), structurecomponent.func_74874_b().func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.length - 8; j += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent1 = this.getNextComponentPP((Start)componentIn, listIn, rand, 0, j);
                if (structurecomponent1 == null) continue;
                j += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            EnumFacing enumfacing = this.func_186165_e();
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.func_74874_b().field_78897_a - 1, this.func_74874_b().field_78895_b, this.func_74874_b().field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        PixieVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_185774_da.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P());
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                block1: for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    BlockPos blockpos = new BlockPos(i, 64, j);
                    if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) continue;
                    if ((blockpos = worldIn.func_175672_r(blockpos).func_177977_b()).func_177956_o() < worldIn.func_181545_F()) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), worldIn.func_181545_F() - 1, blockpos.func_177952_p());
                    }
                    while (blockpos.func_177956_o() >= worldIn.func_181545_F() - 1) {
                        IBlockState iblockstate4 = worldIn.func_180495_p(blockpos);
                        if (iblockstate4.func_177230_c() == Blocks.field_150349_c) {
                            if (!worldIn.func_175623_d(blockpos.func_177984_a())) {
                                worldIn.func_175698_g(blockpos.func_177984_a());
                            }
                            if (!worldIn.func_175623_d(blockpos.func_177981_b(2))) {
                                worldIn.func_175698_g(blockpos.func_177981_b(2));
                            }
                            worldIn.func_180501_a(blockpos, iblockstate, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_185904_a().func_76224_d() || iblockstate4.func_177230_c() == Blocks.field_150432_aD) {
                            worldIn.func_180501_a(blockpos, iblockstate1, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_177230_c() == Blocks.field_150354_m || iblockstate4.func_177230_c() == Blocks.field_150322_A || iblockstate4.func_177230_c() == Blocks.field_180395_cM) {
                            worldIn.func_180501_a(blockpos, iblockstate2, 2);
                            worldIn.func_180501_a(blockpos.func_177977_b(), iblockstate3, 2);
                            continue block1;
                        }
                        blockpos = blockpos.func_177977_b();
                    }
                }
            }
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start start, int type, Random rand, StructureBoundingBox p_i45571_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45571_4_;
        }

        public static House1 createPiece(Start start, List<StructureComponent> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing facing, int p_175850_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175850_1_, (StructureBoundingBox)structureboundingbox) == null ? new House1(start, p_175850_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            this.func_175811_a(worldIn, ModBlocks.pixieHouse.func_176223_P().func_177226_a((IProperty)BlockPixieHouse.FACING, (Comparable)EnumFacing.NORTH), 0, 0, 0, structureBoundingBoxIn);
            BlockPos blockpos = new BlockPos(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0));
            if (worldIn.func_175625_s(blockpos) != null && worldIn.func_175625_s(blockpos) instanceof TileEntityPixieHouse) {
                int houseType;
                ((TileEntityPixieHouse)worldIn.func_175625_s((BlockPos)blockpos)).houseType = houseType = randomIn.nextInt(5);
                if (!worldIn.field_72995_K) {
                    IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdatePixieHouseModel(blockpos.func_177986_g(), houseType));
                }
            } else {
                TileEntityPixieHouse pixieHouse = new TileEntityPixieHouse();
                pixieHouse.houseType = randomIn.nextInt(5);
                worldIn.func_175690_a(blockpos, (TileEntity)pixieHouse);
            }
            this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), 0, -1, 0, structureBoundingBoxIn);
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 0, 1, 0, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        }
    }
}

